require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require_relative '../../module/DriverUtility'
require_relative 'cc_SM_request_helper'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../module/database/MongoUtility'
require 'watir-scroll'

describe '[Story VAR-8698 :CC Request – Appointment Preferences
             Story VAR-10013 : CC Request - Notification Settings - Under VA Scheduling Notifications always require email address
             Story VAR-10871 : VAR -CC Request - Ensure the Veteran\'s email address is always displayed on the request submission and details page.
             Story VAR-11069 : VAR- All CC Requests- Include Message a Scheduling Clerk in the Notification Settings
             Story VAR-8929 :CC Request Details Page - Display CC Appointment Request]
             Story VAR-8927 :CC Request List - Update to include community care]
             Story VAR-10559 :VAR - CC Find PCP - Update Requests table to include Find PCP
             Story VAR-9898 :Add information for Address Fields from Distance Eligibility Check in Details Page
             Story VAR-8928 :VAR - CC Specialty Care Types and Find PCP - View Updated Details Page
             Story VAR-9162 :CC Wizard: Retain saved views when navigating between wizard views]
             Story VAR-9030 :CC Navigate without saving messages - previous and exit buttons
             Story VAR-9313 :New Appointment/Request form – Display Form and Step 1 Select Service;
             Story VAR-9538 : Display Information for Unusual and Excessive Travel Burden
             Story VAR-10150 : VAR - CC Request - Step 2: Distance Eligibility - Text Updates and New question added above unusual and excessive travel burden
             Story VAR-8698 :CC Request – Appointment Preferences
             Story VAR-10013 : CC Request - Notification Settings - Under VA Scheduling Notifications always require email address
             Story VAR-10871 : VAR -CC Request - Ensure the Veteran\'s email address is always displayed on the request submission and details page.
             Story VAR-11069 : VAR- All CC Requests- Include Message a Scheduling Clerk in the Notification Settings
             Story VAR-10387:VAR - CC Find PCP - View Completed Requests;
             Story VAR-10458:VAR- CC Find PCP - Update Request details view
             Story VAR-11042: VAR - CC Find PCP - Veteran Cancelling a Find PCP request
             Story VAR-8698 :CC Request – Appointment Preferences]', :varList_MockService => false do
  include DriverUtility
  include DateUtility
  include OracleUtility
  include MongoUtility
  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @request_appointment_detail = RequestAppointmentDetail.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    deletePatientData("1113138327")
    deleteAllCCRequestData()
    deleteNotificationPreference("1113138327")
    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    @todayhr = getNthHoursFromNow(0)
    @todaymin = getNthMinFromNow(0)
    @fiveDaysLater = getDateNthDaysFromNow(6, "%m/%d/%Y")
    @eightDaysLater = getDateNthDaysFromNow(8,"%m/%d/%Y")
    @sevenDaysLater = getDateNthDaysFromNow(7,"%m/%d/%Y")
    @db = connectToMongoDB("var-utility")
    restoreCollection("communityCareTypeOfCares", "var-utility", "communityCareTypesOfCare.json", @db)
    @cc_po.common.loginEndsOnHome(pw_redacted)
  end

  after(:all) do
    @cc_po.loginLogout.logout
  end

  context "When Authorized VAOS User provides their valid User Name and Password" do

    it "Eligible User should able to select Community Care and fill out the required wizards Step 1 - Step 4 " do
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.eligibility_no_element.click
      @cc_po.communityCare.travel_no_element.click
      @cc_po.communityCare.unusual_no_element.click
      @cc_po.communityCare.address = "2222 Conference Center Dr"
      @cc_po.communityCare.city = "Chantilly"
      @cc_po.communityCare.state = "VA"
      @cc_po.communityCare.zip_code_1st_question = "20151"
      @cc_po.communityCare.zip_code_1st_question_element.fire_event('onblur')
      @cc_po.communityCare.find_nearest_facility
      @cc_po.common.waitWhileSpinnerPresent
      expect(@cc_po.communityCare.eligibility_response_element.text).to eq("You meet preliminary eligibility criteria for community care. Select the \"Continue\" button below to complete a request for care in your community.")
      expect(@cc_po.communityCare.find_nearest_facility_element.disabled?).to eq true
    end

    it "User should able to continue fill out Step 3 and Step 4" do
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.facility_radio_btn_elements[1].click
      @cc_po.communityCare.care_type = "Optometry (routine eye exam)"
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq ("This app currently only supports routine eye exams. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This includes an office visit for an eye exam and vision evaluation, which may include dilating your eyes. The exam may lead to prevention and treatment recommendations, a request for further consultation, and/or a prescription for eye glasses or contact lenses. A routine exam is not for any new or sudden changes with your vision or eyes.")
    end

    it "User shoule able to hit Continue and fill out Step 5 wizard" do
      @cc_po.communityCare.con_yes_element.click
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.execute_script("arguments[0].scrollIntoView();", @cc_po.communityCare.exit_button_element)
      @cc_po.communityCare.choice1_date = @fiveDaysLater
      @cc_po.communityCare.choice1_date_element.fire_event('onblur')
      @cc_po.communityCare.radio_am_pm_elements[1].click
      @cc_po.communityCare.radio_am_pm_elements[1].fire_event('onblur')
      @cc_po.communityCare.choice2_date = @fiveDaysLater
      expect(@cc_po.communityCare.invalid_date_error_elements[0].text).to eq("The Date Entered is not unique.")
      @cc_po.communityCare.choice2_date = @eightDaysLater
      @cc_po.communityCare.radio_am_pm_elements[3].click
      @cc_po.communityCare.continue_btn_element.fire_event('onblur')
      @cc_po.communityCare.clickContinueButton
    end

    it "User Should able to continue and fill out Step 6 wizard" do
      @cc_po.communityCare.provider_city = "Dulles"
      @cc_po.communityCare.provider_state = "VA"
      @cc_po.communityCare.provider_zip = "20166"
      @cc_po.communityCare.preferred_miles_elements[0].click
      @cc_po.communityCare.preferred_lang = "Chinese"
      @cc_po.communityCare.office_hrs_elements[1].click
      @cc_po.communityCare.previous_btn_element.scroll.to :bottom
      @cc_po.communityCare.continue_btn_element.fire_event('onblur')
      @cc_po.communityCare.clickContinueButton
    end

    it "User should able to continue and fillout Step 7 wizard" do
      expect(@cc_po.communityCare.step7_instructions_element.text).to eq("If you need to communicate with a scheduling clerk about this request, you may ask a clerk to call you or you may message a clerk through this app.")
      expect(@cc_po.communityCare.morning_call_element.checked?).to eq true
      expect(@cc_po.communityCare.afternoon_call_element.checked?).to eq true
      expect(@cc_po.communityCare.evening_call_element.checked?).to eq true
      expect(@cc_po.communityCare.phoneCall_requestYes_selected?).to eq false
      expect(@cc_po.communityCare.submit_request_element.disabled?).to eq true
    end

    it "verify Best Times for VAR to Call secton" do
      actual_content = @cc_po.communityCare.phone_call_settings_element.text.split("\n")
      expected_content = [\
        "VA Phone Calls",
        " * Phone: ",
        "* Best Times for VA to Call (Monday through Friday)",
        "Morning",
        "Afternoon",
        "Evening",
        "Would you like the VA to call you regarding this request?",
        "Yes",
        "No",
      ]
      comp_text(expected_content, actual_content)
    end

    it "verify Message to Clerk secton" do
      puts (@cc_po.communityCare.clerk_msg_section_element.text.split("\n"))
      expect(@cc_po.communityCare.clerk_msg_element.attribute("placeholder")).to eq("Messages (100 characters max) should not be used for cancelling an appointment or for clinical questions that may need provider attention.")
      actual_content = @cc_po.communityCare.clerk_msg_section_element.text.split("\n")
      expected_content = [\
         "Message a Scheduling Clerk",
         "(100 char limit)",
         "100 characters remaining",
      ]
      comp_text(expected_content, actual_content)
    end

    it "verify Email Preferences secton" do
      actual_content = @cc_po.communityCare.email_pref_section_element.text.split("\n")
      expected_content = [\
         "VA Scheduling Notifications",
         "Community Care requests require an email address so that we may contact you about your appointment and provide additional instructions as needed.",
         "Please confirm your email before submitting this request.",
         "Send me updates on my appointments and requests:",
         "Information about updates on my appointments and requests", # aria label
         "Yes",
         "No",
         " * Email:"
      ]
      comp_text(expected_content, actual_content)
    end


    it "verify the field validation of Notification Form and fill out the notification settings form" do
      @cc_po.communityCare.phone_required = 344444
      @cc_po.communityCare.phone_required_element.fire_event('onblur')
      expect(@cc_po.communityCare.phone_error_element.text).to eq("Please enter a valid US Phone number.")
      @cc_po.communityCare.phone_required = 3334445555
      @cc_po.communityCare.phone_required_element.fire_event('onblur')
      @cc_po.communityCare.uncheck_morning_call
      @cc_po.communityCare.uncheck_evening_call
      @cc_po.communityCare.phoneCall_requestYes_element.click
      @cc_po.communityCare.phoneCall_requestYes_element.fire_event('onblur')
      expect(@cc_po.communityCare.email_notification_label_element.text).to eq("VA Scheduling Notifications")
      expect(@cc_po.communityCare.email_instruction_elements[0].text).to eq("Community Care requests require an email address so that we may contact you about your appointment and provide additional instructions as needed.")
      expect(@cc_po.communityCare.email_instruction_elements[1].text).to eq("Please confirm your email before submitting this request.")
      @cc_po.communityCare.email_field= "test.test"
      @cc_po.communityCare.email_field_element.fire_event('onblur')
      expect( @cc_po.communityCare.email_error_element.text).to eq("Please enter a valid email address.")
      @cc_po.communityCare.msg_clerk = "This is a test"
      @cc_po.communityCare.msg_clerk_element.fire_event('onblur')
      @cc_po.communityCare.email_field= "test.test@gmail.com"
      @cc_po.communityCare.email_field_element.fire_event('onblur')
      @cc_po.communityCare.email_field_element.send_keys :tab
      @cc_po.communityCare.submit_request_element.click
      @cc_po.common.waitWhileSpinnerPresent
    end

    it "Verify the Status Section View Page" do
      puts (@cc_po.communityCare.provider_preference_sec_element.text.split("\n"))
      @cc_po.communityCare.request_Status_element.when_present(TIME_OUT_LIMIT)
      expect(@cc_po.communityCare.request_Status_element.text).to eq("Status: Submitted")
      expect(@cc_po.communityCare.request_status_msg_element.text).to eq("View status updates for this request under the \"Requests\" section of the Appointments and Requests page. Once scheduled, the resulting appointment will be displayed under the “Appointments” section of the same page.")
    end

    it "Should verify Provide Feedback link is displayed on Submission Confirmation page" do
      expect(@cc_po.detailsView.provide_feedback_link_element.text).to eq("Provide feedback on this submission.")
    end

    it "Verify the Provider Section View Page" do
      actual_content = @cc_po.communityCare.provider_preference_sec_element.text.split("\n")
      expected_content = [\
          "Provider Preferences",
          "Preferred Location",
          "City Dulles State VA Zip Code 20166 How many miles away from this ZIP code are you willing to travel? 10 Preferred Language Spoken Chinese Office Hours Evenings"
      ]
      comp_text(expected_content, actual_content)
    end

    it "Contact Info section should display expected information" do
      expect(@cc_po.communityCare.contact_info_elements[0].text).to eq("Email test.test@gmail.com")
      expect(@cc_po.communityCare.contact_info_elements[1].text).to eq("Phone (333) 444-5555")
      expect(@cc_po.communityCare.contact_info_elements[2].text).to eq("Best Times for VA to Call Afternoon")
    end

    it "should verify the content of Eligibility Details Section" do
      puts (@cc_po.communityCare.eligibility_details_section_element.text).split(",")
      actual_content = (@cc_po.communityCare.eligibility_details_section_element.text).split(/\n/)
      expected_content = [\
          "Eligibility Details:",
          "Are you a distance Eligible Veteran? No Do you need to travel by air, boat, or ferry to the VA medical facility closest to your home? No Are you faced with an excessive burden due to traveling to the closest VA medical facility based on geographic challenges, environmental factors, or a medical condition? No Street Address2222 Conference Center Dr CityChantilly StateVA Zip Code20151"
      ]
      comp_text(expected_content, actual_content)

    end

    it "verify the message sent by Vet on details view page" do
      @cc_po.communityCare.send_msg_btn_element.scroll.to :bottom
      @cc_po.communityCare.msg_details_clerk = "This is second test"
      @cc_po.communityCare.send_msg_btn
      @cc_po.common.waitWhileSpinnerPresent
      expect(@cc_po.communityCare.msg_to_clerk_elements[0].text).to eq("This is second test")
      expect(@cc_po.communityCare.msg_to_clerk_elements[1].text).to eq("This is a test")
    end

    it "User should able to go back to landing page and locate the submitted CC Request" do
      @cc_po.communityCare.app_request_bak_element.scroll.to :top
      @cc_po.communityCare.app_request_bak
      findCCrequestfromRequestsTable
      @request_appointment_detail.cancel_btn_element.scroll.to
      @request_appointment_detail.cancel_btn_element.when_present(TIME_OUT_LIMIT)
      @request_appointment_detail.cancel_btn
      @cc_po.modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@cc_po.modal.modalTitle_element.text).to eq("Confirmation")
      expect(@cc_po.modal.content_element.text).to eq("Are you sure you want to cancel this request?\nSelect Yes to cancel, No to return to the Request details page.")
      @cc_po.modal.no_cancel_request
    end

    it "should add another speciality CC request" do
      @cc_po.communityCare.app_request_bak_element.scroll.to :top
      @cc_po.communityCare.app_request_bak
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.radio_btn_elements[1].click
      @cc_po.communityCare.eligibility_yes_element.click
      @cc_po.communityCare.continue_btn
    end

    it "User should able to continue fill out Step 3 and Step 4" do
      @cc_po.communityCare.facility_radio_btn_elements[1].click
      @cc_po.communityCare.care_type ="Audiology (hearing aid support)"
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This is an office visit for Veterans who already have a hearing aid and who need assistance with the device. This visit is for trouble shooting or adjusting your hearing aid for best performance. This may include technical adjustments, cleaning, and/or reprogramming for new listening situations and environments. This is not a visit to initially be evaluated for or to obtain a hearing aid.")
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq ("This request is for hearing aid support only. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      @cc_po.communityCare.con_yes_element.click
    end

    it "submit CC Request" do
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.execute_script("arguments[0].scrollIntoView();", @cc_po.communityCare.exit_button_element)
      @cc_po.communityCare.choice1_date = @fiveDaysLater
      @cc_po.communityCare.choice1_date_element.fire_event('onblur')
      @cc_po.communityCare.radio_am_pm_elements[1].click
      @cc_po.communityCare.radio_am_pm_elements[1].fire_event('onblur')
      @cc_po.communityCare.continue_btn_element.fire_event('onblur')
      @cc_po.communityCare.clickContinueButton
    end

    it "User Should able to continue and fill out Step 6 wizard" do
      @cc_po.communityCare.provider_city = "Dulles"
      @cc_po.communityCare.provider_state = "VA"
      @cc_po.communityCare.provider_zip = "20166"
      @cc_po.communityCare.preferred_miles_elements[0].click
      @cc_po.communityCare.preferred_lang = "Chinese"
      @cc_po.communityCare.office_hrs_elements[1].click
      @cc_po.communityCare.previous_btn_element.scroll.to :bottom
      @cc_po.communityCare.continue_btn_element.fire_event('onblur')
      @cc_po.communityCare.clickContinueButton
    end

    it "User should able to continue and fillout Step 7 wizard" do
      expect(@cc_po.communityCare.step7_instructions_element.text).to eq("If you need to communicate with a scheduling clerk about this request, you may ask a clerk to call you or you may message a clerk through this app.")
      expect(@cc_po.communityCare.morning_call_element.checked?).to eq true
      expect(@cc_po.communityCare.afternoon_call_element.checked?).to eq true
      expect(@cc_po.communityCare.evening_call_element.checked?).to eq true
      expect(@cc_po.communityCare.phoneCall_requestYes_selected?).to eq false
      expect(@cc_po.communityCare.submit_request_element.disabled?).to eq true
      @cc_po.communityCare.phone_required = 3334445555
      @cc_po.communityCare.phone_required_element.fire_event('onblur')
      @cc_po.communityCare.uncheck_morning_call
      @cc_po.communityCare.uncheck_evening_call
      @cc_po.communityCare.phoneCall_requestYes_element.click
      @cc_po.communityCare.phoneCall_requestYes_element.fire_event('onblur')
      @cc_po.communityCare.msg_clerk = "This is a test"
      @cc_po.communityCare.msg_clerk_element.fire_event('onblur')
      @cc_po.communityCare.email_field= "test.test@gmail.com"
      @cc_po.communityCare.email_field_element.fire_event('onblur')
      @cc_po.communityCare.email_field_element.send_keys :tab
      @cc_po.communityCare.submit_request_element.click
      @cc_po.common.waitWhileSpinnerPresent
      @cc_po.communityCare.app_request_bak_element.scroll.to :top
      @cc_po.communityCare.app_request_bak
    end

    it "submit PCP Request" do
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.radio_btn_elements[1].click
      @cc_po.communityCare.eligibility_yes_element.click
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.facility_radio_btn_elements[1].click
      @cc_po.communityCare.care_type ="Find a Provider (primary care)"
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("If approved, you'll be assigned to a primary care provider in the community to whom we will send the approved referral. Once assigned, you will be provided information and will need to contact the provider’s office directly for preventive and other health care needs for the duration of the approved referral.")
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq ("This request currently only supports the finding of a Primary Care Provider. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      @cc_po.communityCare.con_yes_element.click
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.provider_city = "Dulles"
      @cc_po.communityCare.provider_state = "VA"
      @cc_po.communityCare.provider_zip = "20166"
      @cc_po.communityCare.preferred_miles_elements[0].click
      @cc_po.communityCare.preferred_lang = "Chinese"
      @cc_po.communityCare.office_hrs_elements[1].click
      @cc_po.communityCare.previous_btn_element.scroll.to :bottom
      @cc_po.communityCare.continue_btn_element.fire_event('onblur')
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.phone_required = 3334445555
      @cc_po.communityCare.phone_required_element.fire_event('onblur')
      @cc_po.communityCare.uncheck_morning_call
      @cc_po.communityCare.uncheck_evening_call
      @cc_po.communityCare.phoneCall_requestYes_element.click
      @cc_po.communityCare.phoneCall_requestYes_element.fire_event('onblur')
      @cc_po.communityCare.msg_clerk = "This is a test"
      @cc_po.communityCare.msg_clerk_element.fire_event('onblur')
      @cc_po.communityCare.email_field= "test.test@gmail.com"
      @cc_po.communityCare.email_field_element.fire_event('onblur')
      @cc_po.communityCare.email_field_element.send_keys :tab
      @cc_po.communityCare.submit_request_element.click
      @cc_po.common.waitWhileSpinnerPresent
      @cc_po.communityCare.app_request_bak_element.scroll.to :top
      @cc_po.communityCare.app_request_bak
    end

    it "should submit Nutrition Request" do
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.radio_btn_elements[1].click
      filloutDataforCCAppointmentRequest("Nutrition (routine exam)")
      expect(@cc_po.communityCare.request_Status_element.text).to eq("Status: Submitted")
    end

    def comp_text(expected_content, actual_content)
      expected_content.each_with_index do |expectedScreenRow, i|
        expect(actual_content[i].to_s.strip).to eq(expectedScreenRow.to_s.strip)
      end
    end

  end

end